/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.core.info.GroupInfo;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends Block {
    public GroupInfo group;
    public String blockName = "BlockBase";
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    public int tickRate = 0;
    public boolean removeOnTick = false;
    public boolean loopTicks = true;
    public boolean canBeCrushed = false;
    public boolean noEntityCollision = false;
    public boolean noBreakCollision = false;
    public boolean isOpaque = true;

    public BlockBase(Material material, GroupInfo group, String name) {
        super(material);
        this.group = group;
        this.blockName = name;
        this.setup();
    }

    public BlockBase(Material material) {
        super(material);
    }

    public void setup() {
        this.setRegistryName(new ResourceLocation(this.group.filename, this.blockName.toLowerCase()));
        this.func_149663_c(this.blockName);
    }

    public void copyAttributesTo(Block block) {
        block.func_149711_c(this.field_149782_v);
        block.func_149752_b(this.field_149781_w);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(this.getDescription(stack, player));
    }

    public String getDescription(ItemStack itemStack, EntityPlayer entityPlayer) {
        return I18n.func_74838_a((String)("tile." + this.blockName + ".description"));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.tickRate > 0) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int zero) {
        return super.func_180660_a(state, random, zero);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public BlockStateContainer func_180661_e() {
        return super.func_180661_e();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (this.canBeCrushed && (block == Blocks.field_150354_m || block == Blocks.field_150351_n)) {
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block);
    }

    public int func_149738_a(World world) {
        return this.tickRate;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (this.removeOnTick && this.canRemove(world, pos, state, rand)) {
            world.func_175698_g(pos);
        } else if (this.tickRate > 0 && this.loopTicks) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 1);
        }
    }

    public boolean func_149653_t() {
        return this.tickRate > 0;
    }

    public boolean canRemove(World world, BlockPos pos, IBlockState state, Random rand) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        if (this.noEntityCollision) {
            return true;
        }
        return super.func_176205_b(world, pos);
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.noEntityCollision) {
            return false;
        }
        return super.func_176212_b(world, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        if (!this.func_149703_v()) {
            return Block.field_185506_k;
        }
        return super.func_180646_a(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return super.func_180640_a(state, world, pos);
    }

    public boolean func_149703_v() {
        return !this.noEntityCollision;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isOpaque;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState blockState, Entity entity) {
        super.func_180634_a(world, pos, blockState, entity);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState blockState, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (this.noEntityCollision && world instanceof World) {
            this.func_180634_a((World)world, blockpos, blockState, entity);
        }
        return super.isEntityInsideMaterial(world, blockpos, blockState, entity, yToTest, materialIn, testingHead);
    }

    public BlockBase setBlockStepSound(SoundType soundType) {
        return (BlockBase)this.func_149672_a(soundType);
    }

    public static enum RENDER_TYPE {
        NONE(-1),
        NORMAL(0),
        CROSS(1),
        TORCH(2),
        FIRE(3),
        FLUID(4);

        public final int id;

        private RENDER_TYPE(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

